/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftpbrowser;

import com.quantumdata.ftp.JCoFileTable;
import com.quantumdata.ftpbrowser.FileBrowserPanel;
import com.quantumdata.ftpbrowser.FileListTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class FileListTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private JCoFileTable m_table;
    private FileBrowserPanel m_owner;
    private boolean m_isSource;

    public FileListTransferHandler(JCoFileTable jCoFileTable, FileBrowserPanel fileBrowserPanel) {
        this.m_owner = fileBrowserPanel;
        this.m_table = jCoFileTable;
        this.m_isSource = false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.m_isSource) {
            return false;
        }
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        FileListTransferable fileListTransferable = new FileListTransferable(this.m_table);
        this.m_isSource = true;
        return fileListTransferable;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.m_isSource = false;
    }

    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        boolean bl = false;
        try {
            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            bl = this.m_owner.transferFiles(list);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }
}

